%%
%% jas.cls
\def\fileversion{1.1}
\def\filename{jas}
\def\filedate{2023/08/29}
%%
%% Package 'jas' to use with LaTeX2e for publications on the Journal of Approximation Software
%% Please report issues to: alberto.viscardi@unito.it
%%
\NeedsTeXFormat{LaTeX2e}
\ProvidesClass{jas}[\filedate\space\fileversion\space JAS LaTeX class by Alberto Viscardi]

%% Based on the standard article class
\LoadClass[onecolumn,oneside,a4paper,12pt,final]{article}

%% Layout packages
%\RequirePackage[UTF8]{inputenc}
\RequirePackage[T1]{fontenc}
\RequirePackage{mathptmx,textcomp}

\providecommand{\keywords}[1]{\textbf{Keywords}: #1}

\let\@Shorttitle\@empty 
\protected\def\Shorttitle#1{\gdef\@Shorttitle{#1}}
\let\@Shortauthors\@empty
\protected\def\Shortauthors#1{\gdef\@Shortauthors{#1}}
\let\@Email\@empty
\protected\def\Email#1{\gdef\@Email{#1}}
\let\@Volume\@empty
\protected\def\Volume#1{\gdef\@Volume{#1}}
\let\@Issue\@empty
\protected\def\Issue#1{\gdef\@Issue{#1}}
\let\@Year\@empty
\protected\def\Year#1{\gdef\@Year{#1}}
\let\@Artnum\@empty
\protected\def\Artnum#1{\gdef\@Artnum{#1}}
\let\@Subdate\@empty
\protected\def\Subdate#1{\gdef\@Subdate{#1}}
\let\@Pubdate\@empty
\protected\def\Pubdate#1{\gdef\@Pubdate{#1}}
\let\@DOI\@empty
\protected\def\DOI#1{\gdef\@DOI{#1}}
\let\@Comby\@empty
\protected\def\Comby#1{\gdef\@Comby{#1}}

\RequirePackage[margin=1in]{geometry}%1.38in

\RequirePackage[usenames,dvipsnames]{xcolor}
\definecolor{blue}{rgb}{0, 0.4470, 0.7410}
\definecolor{orange}{rgb}{0.8500, 0.3250, 0.0980}
\definecolor{yellow}{rgb}{0.9290, 0.6940, 0.1250}
\definecolor{purple}{rgb}{0.4940, 0.1840, 0.5560}
\definecolor{green}{rgb}{0.4660, 0.6740, 0.1880}
\definecolor{azure}{rgb}{0.3010, 0.7450, 0.9330}
\definecolor{red}{rgb}{0.6350, 0.0780, 0.1840}

\RequirePackage{hyperref,url}
\hypersetup{
	colorlinks=true,
	linkcolor=red,
	citecolor=green,
	filecolor=purple,      
	urlcolor=blue,
	breaklinks=true
}
\urlstyle{same}

\RequirePackage{fancyhdr,lastpage}
\pagestyle{fancy}
\renewcommand{\headrulewidth}{1pt}
\renewcommand{\footrulewidth}{1pt}
\fancyhf{}
\fancyhead[L]{\includegraphics[height=12pt]{JAS_logo_black.pdf}}
\fancyhead[R]{ \@Shorttitle }
\fancyfoot[L]{ \@Shortauthors }
\fancyfoot[R]{\hyperlink{firstpage}{\thepage}/\pageref{LastPage}}
\fancypagestyle{firstpage}{
	\renewcommand{\headrulewidth}{0pt}
	\renewcommand{\footrulewidth}{1pt}
	\fancyhf{}
	\fancyfoot[L]{$^\star$ Corresponding author: \url{\@Email}}
	\fancyfoot[R]{\hyperlink{firstpage}{\thepage}/\pageref{LastPage}}
}

\RequirePackage[noblocks,auth-lg,affil-it]{authblk}
\setcounter{Maxaffil}{10}
\renewcommand\Authfont{\large}
\renewcommand\Affilfont{\itshape\small}
\setlength{\affilsep}{1em}
\renewcommand\Authsep{,$\quad$}
\renewcommand\Authand{$\quad${\normalfont and}$\quad$}
\renewcommand\Authands{,$\quad${\normalfont and}$\quad$}

\RequirePackage{orcidlink}

\RequirePackage{graphicx, tabularx, ragged2e}
\renewcommand{\maketitle}{%
	\thispagestyle{firstpage}
	\begin{center}
		\rule{\textwidth}{1pt}
		\begin{tabular}{m{0.24\textwidth} m{0.74\textwidth}}
			\vspace{1.1cm}\includegraphics[width=0.24\textwidth]{JAS_logo_black.pdf} & 
			\begin{tabular}{c}
				{\small J. Approx. Softw.,$\,$ Vol. \@Volume,$\,$ No. \@Issue$\,$ (\@Year)$\,$ \@Artnum}\\ \\
				\href{https://www.ojs.unito.it/index.php/JAS}{\LARGE\bfseries Journal of Approximation Software}\\  \\
				\phantom{\small doi:$\;$\@DOI $\quad$--$\quad$ ISSN:$\;$0000--0000}
			\end{tabular}
		\end{tabular}
		$ $\\
		\rule{\textwidth}{1pt}
		$ $\\
		$ $\\
		\hypertarget{firstpage}{{\Huge\@title}}\\
		$ $\\
		{\@author}\\
		$ $\\
		{\small Received: \@Subdate $\quad$--$\quad$ Published: \@Pubdate}\\
		{\small Communicated by: \@Comby}
		$ $\\
	\end{center}
}

%% Math packages and environments
\RequirePackage{amsmath,amsthm,amssymb,mathtools,bm}

\theoremstyle{plain}
\newtheorem{thm}{Theorem}[section]
\newtheorem{lem}[thm]{Lemma}
\newtheorem{prop}[thm]{Proposition}
\newtheorem{cor}[thm]{Corollary}

\theoremstyle{definition}
\newtheorem{defn}{Definition}[section]
\newtheorem{exmp}{Example}[section]

\theoremstyle{remark}
\newtheorem{rem}{Remark}[section]

%% Code packages
\RequirePackage{listings}
\lstset{
	commentstyle=\color{green} , 
	basicstyle=\fontfamily{pcr}\selectfont\scriptsize\bfseries, 
	keywordstyle=\color{blue}, 
	numberstyle=\fontfamily{pcr}\selectfont\color{gray}\scriptsize\bfseries, 
	stringstyle=\color{magenta}, 
	showspaces=false, 
	showstringspaces=false,
	showtabs=false, 
	numbers=left, 
	captionpos=t, 
	frame=single, 
	breaklines, 
	keepspaces, 
	rulecolor=\color{black}  
}
\renewcommand{\lstlistingname}{Code}
%\RequirePackage[ruled,linesnumbered]{algorithm2e}
%\SetKwComment{Comment}{\% }{}
%\renewcommand{\KwSty}[1]{{\fontfamily{pcr}\selectfont\color{blue}\bfseries #1}}
%\renewcommand{\CommentSty}[1]{{\fontfamily{pcr}\selectfont\color{green}\bfseries #1}}
%\renewcommand{\NlSty}[1]{{\fontfamily{pcr}\selectfont\color{gray}\scriptsize\bfseries #1}}

%% Bibliography
\RequirePackage[numbers,nonamebreak]{natbib}
\bibliographystyle{jas}%{abbrvnat}